Attribute VB_Name = "modManageAliases"
'-----------------------------------------------------
' MirageBot Aliases Module
' Written by Christopher Nevin (lancergli@gmail.com)
'-----------------------------------------------------

Option Explicit

Private Tags() As String, ChannelTags() As String

Public Function GetAlias(Index As Integer, Username As String) As String
    Dim temp As String
    If HasAlias(Index, Username, temp) Then
        If LenB(temp) <> 0 Then
            GetAlias = temp & IIf(Options.AliasPlus, " (" & Suffix(Username) & ")", vbNullString)
        Else
            GetAlias = Suffix(Username)
        End If
    Else
        GetAlias = Suffix(Username)
    End If
End Function

Public Sub LoadTags()
On Error GoTo hErr
    ReDim Tags(0), ChannelTags(0)
    Dim strLine As String
    Dim ts As TextStream
    Set ts = ReadFile(AppData & "Data\Preferences\Tags\Users.txt")
    Do Until (ts.AtEndOfStream)
        strLine = ts.ReadLine()
        If InStrB(strLine, "|") <> 0 Then
            ReDim Preserve Tags(UBound(Tags) + 1)
            Tags(UBound(Tags)) = strLine
        End If
    Loop
    ts.Close
    Set ts = ReadFile(AppData & "Data\Preferences\Tags\Channels.txt")
    Do Until (ts.AtEndOfStream)
        strLine = ts.ReadLine()
        If InStrB(strLine, "|") <> 0 Then
            ReDim Preserve ChannelTags(UBound(ChannelTags) + 1)
            ChannelTags(UBound(ChannelTags)) = strLine
        End If
    Loop
    ts.Close
    Exit Sub
hErr:
    ErrorHandler Err, Erl, "Tags", "LoadTags"
End Sub

Public Function HasAlias(ByVal Index As Integer, ByVal Username As String, ByRef Alias As String) As Boolean
On Error GoTo hErr
    Alias = vbNullString
    HasAlias = False
    Dim i As Integer, User As String
    User = LCase$(frmBot.Bot(Index).GetAccount(Username))
    For i = 0 To UBound(Tags)
        Dim Splt() As String
        Splt() = Split(Tags(i), "|")
        If UBound(Splt) = 1 Then
            If User = LCase$(frmBot.Bot(Index).GetAccount(Splt(0))) Then
                Alias = Splt(1)
                HasAlias = True
                Exit Function
            End If
        End If
    Next i
    Exit Function
hErr:
    ErrorHandler Err, Erl, "Tags", "HasAlias"
End Function

Public Function HasChannelAlias(ByVal Channel As String, ByRef Alias As String) As Boolean
On Error GoTo hErr
    Alias = vbNullString
    HasChannelAlias = False
    Channel = LCase$(Channel)
    Dim i As Integer
    For i = 0 To UBound(ChannelTags)
        Dim Splt() As String
        Splt() = Split(ChannelTags(i), "|")
        If UBound(Splt) = 1 Then
            If Channel = LCase$(Splt(0)) Then
                Alias = Splt(1)
                HasChannelAlias = True
                Exit Function
            End If
        End If
    Next i
    Exit Function
hErr:
    ErrorHandler Err, Erl, "ChannelTags", "HasChannelAlias"
End Function
